VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.Form frmPulseChart 
   Caption         =   "2520 Single Pulse Chart"
   ClientHeight    =   7080
   ClientLeft      =   1815
   ClientTop       =   3450
   ClientWidth     =   9645
   LinkTopic       =   "Form1"
   ScaleHeight     =   7080
   ScaleWidth      =   9645
   Begin VB.Frame fraPulseScale 
      Caption         =   "Scale Y Axes"
      Height          =   1335
      Left            =   360
      TabIndex        =   2
      Top             =   5640
      Width           =   6375
      Begin VB.CommandButton cmdPulseReplot 
         Caption         =   "Replot"
         Height          =   375
         Left            =   2400
         TabIndex        =   11
         Top             =   720
         Width           =   1335
      End
      Begin VB.TextBox txtY2Min 
         Height          =   285
         Left            =   5160
         TabIndex        =   8
         Top             =   960
         Width           =   855
      End
      Begin VB.TextBox txtY2Max 
         Height          =   285
         Left            =   5160
         TabIndex        =   7
         Top             =   600
         Width           =   855
      End
      Begin VB.TextBox txtY1Min 
         Height          =   285
         Left            =   120
         TabIndex        =   4
         Top             =   960
         Width           =   855
      End
      Begin VB.TextBox txtY1Max 
         Height          =   285
         Left            =   120
         TabIndex        =   3
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label3 
         Appearance      =   0  'Flat
         BackColor       =   &H80000004&
         Caption         =   "Detector Current (Right)"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   4560
         TabIndex        =   13
         Top             =   285
         Width           =   1695
      End
      Begin VB.Label Label2 
         Appearance      =   0  'Flat
         BackColor       =   &H80000004&
         Caption         =   "LD Voltage (Left)"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   280
         Width           =   1455
      End
      Begin VB.Label lblY2Min 
         Caption         =   "Minimum"
         Height          =   255
         Left            =   4320
         TabIndex        =   10
         Top             =   960
         Width           =   735
      End
      Begin VB.Label lblY2Max 
         Caption         =   "Maximum"
         Height          =   255
         Left            =   4320
         TabIndex        =   9
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label1 
         Caption         =   "Minimum"
         Height          =   255
         Left            =   1080
         TabIndex        =   6
         Top             =   960
         Width           =   975
      End
      Begin VB.Label lblY1Max 
         Caption         =   "Maximum"
         Height          =   255
         Left            =   1080
         TabIndex        =   5
         Top             =   600
         Width           =   975
      End
   End
   Begin VB.TextBox txtPulseXaxis 
      Appearance      =   0  'Flat
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   1440
      Locked          =   -1  'True
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   5160
      Width           =   4095
   End
   Begin MSChart20Lib.MSChart MSChart2 
      Height          =   4695
      Left            =   0
      OleObjectBlob   =   "frmPulseChart.frx":0000
      TabIndex        =   0
      Top             =   720
      Width           =   8655
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   590
      Left            =   6720
      Picture         =   "frmPulseChart.frx":CEA2
      Stretch         =   -1  'True
      Top             =   0
      Width           =   2700
   End
End
Attribute VB_Name = "frmPulseChart"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public Sub Label_PulseChart()
'This sub puts the correct labels in the legend of the chart and
'excludes (hides) unnecessary series on the graph

MSChart2.row = 1                    'address row
MSChart2.RowLabel = "LD Voltage"    'caption row
MSChart2.row = 2
MSChart2.RowLabel = "Det 1 Current"
MSChart2.row = 3
MSChart2.RowLabel = "Det 2 Current"
MSChart2.row = 4
MSChart2.RowLabel = "Detector 2-BF"


'Use secondary (right side) y axis for the LD Voltage
MSChart1.Plot.SeriesCollection(intLDVolt).SecondaryAxis = True
MSChart1.Plot.SeriesCollection(int2ndDeriv).SecondaryAxis = True
'MSChart1.Plot.

'Hide the Detector 2 series, not necessary for resistor DUT
'because of the det1-det2 configuration
If frmMain.optDUTtype(0).value Or frmMain.optDUTtype(1).value Then      'If using 500 mA or 5A DUT (Not Expert mode), hide Det2
    MSChart1.Plot.SeriesCollection(4).Position.Excluded = True
    MSChart1.row = 3
    MSChart1.RowLabel = "Detector"                                      'Relabel Det1 to Detector, since no other Det channels are displayed
    Else                                'If the DUT type is Expert then activate Det 2 series
    MSChart1.Plot.SeriesCollection(4).Position.Excluded = False
    MSChart1.row = 3
    MSChart1.RowLabel = "Detector 1-FF"                                 'Relabel Det1
End If

DoEvents    'update display

End Sub


Private Sub cmdPulseReplot_Click()
'This command permits rescaling of either/both Y axes of the PulseChart

If txtY1Max.Text <> "" And txtY1Min.Text <> "" Then 'If values are entered, then rescale Y1 (left) axis
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Auto = False     'Shut off auto-scaling
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Maximum = txtY1Max.Text
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Minimum = txtY1Min.Text
End If

If txtY2Max.Text <> "" And txtY2Min.Text <> "" Then 'If values are entered, then rescale Y2 (right) axis
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Auto = False     'Shut off auto-scaling
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Maximum = txtY2Max.Text
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Minimum = txtY2Min.Text
End If

End Sub

Private Sub Form_Initialize()

cmdPulseReplot.ToolTipText = "(re)plotting with very small values (10E-5 or so), is somewhat flakey.  Sorry."
fraPulseScale.ToolTipText = "To zoom a Y scale, just type in the min and max for the left and/or right scale, then press replot."
Label2.ToolTipText = "To zoom a Y scale, just type in the min and max for the left and/or right scale, then press replot."
Label3.ToolTipText = "To zoom a Y scale, just type in the min and max for the left and/or right scale, then press replot."

End Sub

Private Sub Form_Load()
'Position form on screen
Top = Screen.Height - Height            'Position form in lower left corner
Left = 0                                'Position form in lower left corner

End Sub

Private Sub MSChart2_PointSelected(Series As Integer, DataPoint As Integer, MouseFlags As Integer, Cancel As Integer)
'This routine zooms in on pulse data by changing the y-axis based on
'99% and 101% of the point selected

If Series = intPulseVolt Then       'Zoom in on LD voltage pulse
    
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Auto = False     'Shut off auto-scaling
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Minimum = 0.99 * (sngPulseArray(Series, DataPoint))
    MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Maximum = 1.01 * (sngPulseArray(Series, DataPoint))
    txtY1Max.Text = MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Maximum  'Copy axis max to text box
    txtY1Min.Text = MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Minimum  'Copy axis min to text box

Else                    'Zoom in on Detector current pulse
    
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Auto = False     'Shut off auto-scaling
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Minimum = 0.99 * (sngPulseArray(Series, DataPoint))
    MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Maximum = 1.01 * (sngPulseArray(Series, DataPoint))
    txtY2Max.Text = MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Maximum  'Copy axis max to text box
    txtY2Min.Text = MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Minimum  'Copy axis min to text box

End If

DoEvents

End Sub
